﻿#define _CRT_SECURE_NO_WARNINGS

#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <queue>
#include <deque>
#include <set>
#include <map>
#include <iomanip>
#include <cmath>

typedef long long ll;
typedef long double ld;

using namespace std;

const int N = 1e3 + 1;
const int INT_INF = 1e9;
const ll LONG_INF = 1e18;

struct Dfs {
    vector<int> a[N];
    bool used[N];

    void dfs(int v) {
        used[v] = true;
        for (auto t : a[v]) {
            if (!used[t]) {
                dfs(t);
            }
        }
    }

};

struct Bfs {
    vector<int> a[N];
    bool used[N];

    void bfs(int v) {
        queue<int> q;
        q.push(v);

        while (!q.empty())
        {
            int t = q.front();
            used[t] = true;
            q.pop();

            for (auto to : a[t]) {
                if (!used[to]) {
                    q.push(to);
                }
            }
        }
    }
};

struct Djikstra {
    vector<pair<ll, int>> a[N];

    vector<ll> djikstra(int v) {
        vector<ll> ans(N);
        ans[v] = LONG_INF;

        set<pair<ll, int>> s;
        s.insert({ 0, v });

        while (!s.empty())
        {
            int t = s.begin()->second;
            s.erase(s.begin());

            for (auto to : a[t]) {
                if (ans[to.second] > ans[t] + to.first) {
                    s.erase({ ans[to.second], to.second });
                    ans[to.second] = ans[t] + to.first;
                    s.insert({ ans[to.second], to.second });
                }
            }
        }

        return ans;
    }
};

struct SegTree {
    ll tree[N];
    ll a[N];

    void update(int v, int l, int r, int x, int id) {
        if (l == r - 1) {
            tree[v] = x;
            return;
        }
        
        int m = (l + r) / 2;
        if (m > id) {
            update(2 * v + 1, l, m, x, id);
        }
        else {
            update(2 * v + 2, m, r, x, id);
        }

        tree[v] = tree[2 * v + 1] + tree[2 * v + 2];
    }

    ll get(int v, int l, int r, int ql, int qr) {
        if (l >= qr || r <= ql) {
            return 0;
        }
        if (l >= ql && r <= qr) {
            return tree[v];
        }

        int m = (l + r) / 2;
        return get(2 * v + 1, l, m, ql, qr) + get(2 * v + 2, m, r, ql, qr);
    }
};

ll gcd(ll a, ll b) {
    return (b == 0) ? a : gcd(b, a % b);
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    //freopen("in.txt", "r", stdin);
    //freopen("out.txt", "w", stdout);

    int t; cin >> t;
    while (t--)
    {
        ld w0, h0, w, h, x, y; cin >> w0 >> h0 >> w >> h >> x >> y;

        //cout << ceil((h0 - y - h) / h) * ceil(x / w) + ceil((h0 - y - h) / h) + ceil((h0 - y - h) / h) * ceil((w0 - x - w) / w)

        //cout << ceil((h0 - y - h) / h) * ceil(x / w) + ceil((h0 - y - h) / h) + ceil((h0 - y - h) / h) * ceil(w0 - x - w);
        //cout << ceil((h0 - y - h) / h) * (ceil(x / w) + ceil(w0 - x - w) + 1) + ceil(y / h) * (ceil(x / w) + ceil(w0 - x - w) + 1);
        ll ans = (ceil(x / w) + ceil((w0 - x - w) / w) + 1) * (ceil((h0 - y - h) / h) + ceil(y / h)) + ceil((w0 - x - w) / w) + ceil(x / w);
        cout << ans << '\n';
    }


    return 0;
}
